/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.execution;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.LimitHandler;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class StalactiteQueryMethodInvocationParameters
extends ParametersParameterAccessor
implements LimitHandler {
    public static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final StalactiteQueryMethod method;
    private Limit limit;

    public StalactiteQueryMethodInvocationParameters(StalactiteQueryMethod method, Object[] values) {
        super((Parameters)method.getParameters(), values);
        this.method = method;
    }

    public Object[] getValues() {
        return super.getValues();
    }

    public Class<?> getDynamicProjectionType() {
        if (this.getParameters().hasDynamicProjection()) {
            return (Class)this.getValues()[this.getParameters().getDynamicProjectionIndex()];
        }
        return null;
    }

    public Map<String, Object> getNamedValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Parameter bindableParameter : this.getParameters().getBindableParameters()) {
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = this.getBindableValue(bindableParameter.getIndex());
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                value = values.length == 1 ? values[0] : Arrays.asList((Object[])values);
            }
            result.put(parameterName, value);
        }
        return result;
    }

    public Map<String, PreparedStatementWriter<?>> bindParameters(Dialect dialect) {
        HashMap result = new HashMap();
        RelationalParameters bindableParameters = (RelationalParameters)this.method.getParameters().getBindableParameters();
        for (RelationalParameters.RelationalParameter bindableParameter : bindableParameters) {
            Class<Object> valueType;
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = this.getBindableValue(bindableParameter.getIndex());
            if (value instanceof Iterable) {
                ResolvableType resolvableType = bindableParameter.getResolvableType();
                valueType = resolvableType.getGeneric(new int[]{0}).resolve();
            } else {
                valueType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            }
            PreparedStatementWriter writer = dialect.getColumnBinderRegistry().getWriter(valueType);
            result.put(parameterName, writer);
        }
        return result;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public void limit(int count) {
        this.setLimit(new Limit(Integer.valueOf(count)));
    }

    @Override
    public void limit(int count, Integer offset) {
        this.setLimit(new Limit(Integer.valueOf(count), offset));
    }
}

